
function AISMN_GoToSpot::OnEnter(%this, %data)
{
   %posX = GetParameterX(%data);
   %posY = GetParameterY(%data);

   // do not attempt to walk (with the walk animation) if there
   // is no path to the destination
   if (SetPathToSpot(%data, %posX, %posY) == true)
   {
      GetThisObject(%data).playThread(0, "run");
   }
}

function AISMN_GoToSpot::OnExit(%this,%obj)
{
   %target = GetParameterTarget(%obj);
   if (isObject(%target)) 
   {
      MsgSender.sendMsg($MSG_SLGOBJMOVE, $MRT_LOCAL, GetThisObject(%obj), %target);
   }
}

function AISMN_GoToSpot::Update(%this,%obj)
{
   if (!IsFollowingPath(%obj))
   {
      // ensure that the character has stopped moving
      GetThisObject(%obj).playThread( 0, "root");
      SetSpeedScalar(%obj,1.0);
      StopMoving(%data);
      
      ReturnValue(%obj,0);
      return;
   }
   
   ReturnValue(%obj,-1);
}

function AISMN_ForceToSpot::OnEnter(%this, %data)
{
   %posX = GetParameterX(%data);
   %posY = GetParameterY(%data);

   ForcePathToSpot(%data, %posX, %posY);
   GetThisObject(%data).playThread(0, "run");
}

function AISMN_ForceToSpot::OnExit(%this,%obj)
{
   GetThisObject(%obj).playThread( 0, "root");
   SetSpeedScalar(%obj,1.0);
   %target = GetParameterTarget(%obj);
   if(isObject(%target)) 
      MsgSender.sendMsg($MSG_SLGOBJMOVE, $MRT_LOCAL, GetThisObject(%obj), %target);

   // ensure that the character has stopped moving
   StopMoving(%data);
}

function AISMN_ForceToSpot::Update(%this,%obj)
{
   if(!IsFollowingPath(%obj))
   {
      ReturnValue(%obj,0);
      return;
   }
   
   ReturnValue(%obj,-1);
}
